
-- Database Structure for Bot Club / Betting Site

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+06:00";

--
-- Table structure for table `users`
--
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `password` varchar(255) NOT NULL,
  `balance` decimal(20,2) DEFAULT 0.00,
  `u_id` varchar(20) NOT NULL COMMENT 'Unique User ID for Referral',
  `referrer_u_id` varchar(20) DEFAULT NULL COMMENT 'Upline User ID',
  `created_at` timestamp DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `phone` (`phone`),
  UNIQUE KEY `u_id` (`u_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Table structure for table `bets`
--
CREATE TABLE `bets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `game_type` varchar(20) NOT NULL COMMENT 'e.g., wingo30s, wingo1m',
  `period` bigint(20) NOT NULL,
  `selection` varchar(20) NOT NULL COMMENT 'Green, Red, Violet, Big, Small, 0-9',
  `amount` decimal(20,2) NOT NULL,
  `status` enum('pending','win','loss') DEFAULT 'pending',
  `win_amount` decimal(20,2) DEFAULT 0.00,
  `bet_time` timestamp DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Table structure for table `game_results`
--
CREATE TABLE `game_results` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `game_type` varchar(20) NOT NULL,
  `period` bigint(20) NOT NULL,
  `result_number` int(1) NOT NULL,
  `result_color` varchar(20) NOT NULL,
  `result_size` enum('Big','Small') NOT NULL,
  `created_at` timestamp DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `game_period` (`game_type`, `period`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Table structure for table `deposits`
--
CREATE TABLE `deposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `method` varchar(20) NOT NULL COMMENT 'bKash, Nagad',
  `amount` decimal(20,2) NOT NULL,
  `transaction_id` varchar(50) NOT NULL,
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  `request_time` timestamp DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Table structure for table `withdrawals`
--
CREATE TABLE `withdrawals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `method` varchar(20) NOT NULL,
  `account_number` varchar(20) NOT NULL,
  `amount` decimal(20,2) NOT NULL,
  `status` enum('pending','approved','rejected') DEFAULT 'pending',
  `request_time` timestamp DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Table structure for table `settings` (Admin Control)
--
CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notice_text` text DEFAULT NULL,
  `bkash_number` varchar(20) DEFAULT NULL,
  `nagad_number` varchar(20) DEFAULT NULL,
  `min_deposit` decimal(10,2) DEFAULT 100.00,
  `min_withdraw` decimal(10,2) DEFAULT 500.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

--
-- Insert Default Settings
--
INSERT INTO `settings` (`notice_text`, `bkash_number`, `nagad_number`) VALUES 
('Welcome to BOT CLUB! Play responsibly.', '01700000000', '01800000000');

COMMIT;
